define([
    'marionette',
    'jquery',
],
function (Marionette, $) {
    'use strict';

    return Marionette.Behavior.extend({
        id: 'addFocusOnHeader',
        onAfterShow: function() {
            this.focusOnHeader();
        },
        ui: {'header': '.header-partial'},
        focusOnHeader: function() {
            var $main = $('#main');
            // content region #main has aria-hidden="true" when
            // loading spinner is visible, panel is open,
            // or popup is active (open)
            if ($main.attr('aria-hidden') !== 'true') {
                this.ui.header.first().focus();
            }
        },
    });
});
